function [ outlineX, outlineY, dropX, dropY ] = Graphics_PlotPendantDrop_V03( R, H, port_radius, thickness, n, PixSize, WinWidth, WinHeight, Up )



% ---------------
% Set up the variables
% ---------------
outlineX = zeros(n,1)  ;
outlineY = zeros(n,1)  ;
dropX    = zeros(n,1)  ;
dropY    = zeros(n,1)  ;

% ---------------
% Visualization paraameters
% ---------------
Radius  = R / PixSize           ;
Height  = H / PixSize           ;
PRadius = port_radius / PixSize ;
th      = thickness / PixSize   ;
xCenter = 0                     ;
yCenter = th - Radius + Height  ;
ww      = WinWidth / PixSize    ;
wh      = WinHeight / PixSize   ;

% ---------------
% make the outline
% ---------------

for i=1:n/4
    outlineX(i)       = -(PRadius + i*4*(ww-PRadius)/n) * PixSize  ;
    outlineY(i)       = Up * th * PixSize             ;
end
for i=1:n/4
    outlineX(i+n/4)   = - PRadius * PixSize            ;
    outlineY(i+n/4)   = Up * i * 4 /n * th * PixSize  ;
end
for i=1:n/4
    outlineX(i+n/2)   = PRadius * PixSize              ;
    outlineY(i+n/2)   = Up * i * 4 /n * th * PixSize  ;
end
for i=1:n/4
    outlineX(i+3*n/4) = (PRadius + i*4*(ww-PRadius)/n) * PixSize  ;
    outlineY(i+3*n/4) = Up * th * PixSize             ;
end

% ---------------
% make the surface plot
% ---------------
for i=1:n/2
    ycoord       = (th + i * 2 * Height / n) ;
    dropY(i)     = Up * ycoord * PixSize ;
    dropX(i)     = (sqrt( Radius^2 - (ycoord - yCenter)^2 ) + xCenter) * PixSize ;
end
for i=1:n/2
    ycoord       = (th + i * 2 * Height / n) ;
    dropY(i+n/2) = Up * ycoord * PixSize ;
    dropX(i+n/2) = (-sqrt( Radius^2 - (ycoord - yCenter)^2 ) + xCenter) * PixSize ;
end


end


